﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Bed occupancy count 
    /// </summary>
    public class BedOccupancyCount
    {
        /// <summary>
        /// Gets or sets the facility id.
        /// </summary>
        /// <value>
        /// The facility id.
        /// </value>
        public II FacilityId { get; set; }

        public string DivisionName { get; set; }

        /// <summary>
        /// Gets or sets the occupancy percent.
        /// </summary>
        /// <value>
        /// The occupancy percent.
        /// </value>
        public int OccupancyPercent { get { return TotalBeds == 0 ? 0 : (int)((double)(TotalOccupiedBeds) / (TotalBeds - TotalUnavailableBeds) * 100); } }

        public int TotalBeds { get; set; }
        public int TotalUnavailableBeds { get; set; }

        public int TotalOccupiedBeds { get; set; }

        public string CensusCategory { get; set; }
    }
}
